-----------------------------------------------------------------------------
--                                                                         --
-- Copyright (c) 1994 by Altera Corp.  All rights reserved.                --
--                                                                         --
--                                                                         --
--  Description:  This file contains macro function A_8COUNT               --
--                                                                         --
--                                                                         --
--                                                                         --
-----------------------------------------------------------------------------
library pack1076;
use pack1076.pack1076.all;

library synth;
use synth.stdsynth.all;

entity A_8COUNT is
	port (A, B, C, D, E, F, G, H : in VLBIT;
	      LDN, GN, DNUP, SETN, CLRN, CLK: in VLBIT;
	      QA, QB, QC, QD, QE, QF, QG, QH, COUT : out VLBIT);
end A_8COUNT;

architecture BEHAVIOR of A_8COUNT is
        constant SIZE : integer := 7;
        signal QBUS : VLBIT_VECTOR(SIZE downto 0);
	signal tmp : VLBIT_VECTOR(SIZE downto 0);
begin
	process
               variable tmp1: VLBIT_VECTOR(SIZE+1 downto 0);
               variable carry: VLBIT;
	begin

                wait until (CLK'event and CLK = '1') or CLRN = '0' or SETN = '0' ;
		if CLRN = '0' then
                   if SETN = '1' then
		      tmp <= "00000000";
                   end if;
		elsif SETN = '0' then
                   if CLRN = '1' then
	               tmp <= (H&G&F&E&D&C&B&A);
                   end if;
		else
		   if LDN = '0' then
			tmp <= (H&G&F&E&D&C&B&A);
		   elsif DNUP = '1' and GN = '0' then
                        tmp1 := subum(tmp, "00001");
                        tmp(SIZE downto 0) <= tmp1(SIZE downto 0);
		   elsif DNUP = '0' and GN = '0' then
                        tmp1 := addum(tmp, "00001");
                        tmp(SIZE downto 0) <= tmp1(SIZE downto 0);
		   end if;
		end if;
	end process;

              COUT <= ((not DNUP) and (not GN) and LDN and tmp(0) and tmp(1)
                         and tmp(2) and tmp(3) and tmp(4) and tmp(5) and tmp(6)
                         and tmp(7))    or
                        (DNUP and (not GN) and LDN and ((not tmp(0)) and
                         (not tmp(1)) and (not tmp(2)) and (not tmp(3)) and
                         (not tmp(4)) and (not tmp(5)) and (not tmp(6)) and
                         (not tmp(7))));

	QBUS <= tmp;

        QA <= QBUS(0); 
        QB <= QBUS(1);
        QC <= QBUS(2);
        QD <= QBUS(3);
        QE <= QBUS(4);
        QF <= QBUS(5);
        QG <= QBUS(6);
        QH <= QBUS(7);
end BEHAVIOR;

